<?php

require __DIR__ . '/vendor/autoload.php';
require __DIR__ . '/config.php';

use Zounar\PHPProxy\Proxy;

$debug = false;

Proxy::$AUTH_KEY = AUTH_KEY;

if (!function_exists('getallheaders')) {
    function getallheaders() {
        $headers = [];
        foreach ($_SERVER as $name => $value) {
            if (substr($name, 0, 5) == 'HTTP_') {
                $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
            }
        }

        return $headers;
    }
}

if($debug) {
    $log = '';
    $log .= 'Request time: ' . date('Y-m-d H:i:s') . "\n";
    $log .= 'Request URI: ' . $_SERVER['REQUEST_URI'] . "\n";
    $log .= 'Request method: ' . $_SERVER['REQUEST_METHOD'] . "\n";
    $log .= 'Request headers: ' . "\n";
    foreach (getallheaders() as $name => $value) {
        $log .= "$name: $value\n";
    }
}

// Disable PHP's output buffering
ob_end_clean();

$response = Proxy::run();

// Make sure the connection is not kept alive
header("Connection: close");

if($debug) {
    $log .= "\n";
    $log .= json_encode($response);
    file_put_contents(__DIR__ . '/log.txt', $log, FILE_APPEND);
}